﻿function init_map() {

    var mapDivName = 'map-data';
    var mapDiv = $('#' + mapDivName);

    var zoom = mapDiv.data('zoom');
    var centerX = mapDiv.data('xcenter');
    var centerY = mapDiv.data('ycenter');
    var showLabels = mapDiv.data('showlabels');
    var opacity = mapDiv.data('opacity');
    if (typeof centerX == 'string' || centerX instanceof String) {
        centerX = centerX.replace(",", ".");
    }
    if (typeof centerY == 'string' || centerY instanceof String) {
        centerY = centerY.replace(",", ".");
    }
    centerX = parseFloat(centerX);
    centerY = parseFloat(centerY);

    var myOptions =
      {
          zoom: zoom,
          center: new google.maps.LatLng(centerY, centerX),
          mapTypeId: google.maps.MapTypeId.HYBRID
      };

    var initialize = function () {
        map = new google.maps.Map(document.getElementById("gmap_canvas"), myOptions);

        $('.map-item').each(function () {

            var content = $(this).data('content');
            var positionX = $(this).data('xposition');
            var positionY = $(this).data('yposition');

            if (typeof positionX == 'string' || positionX instanceof String) {
                positionX = positionX.replace(",", ".");
            }
            if (typeof positionY == 'string' || positionY instanceof String) {
                positionY = positionY.replace(",", ".");
            }

            positionX = parseFloat(positionX);
            positionY = parseFloat(positionY);

            var markerOpacity = parseFloat(opacity);

            var marker = new google.maps.Marker(
            {
                map: map,
                position: new google.maps.LatLng(positionY, positionX),
                opacity: markerOpacity
            });

            var infowindow = new google.maps.InfoWindow(
                {
                    content: content
                });
            google.maps.event.addListener(marker, "click", function () {
                infowindow.open(map, marker);
            });

            if (showLabels === "True") {
                infowindow.open(map, marker);
            }
        });
    };

    // fix for vertical tabs
    $("#mapTab").click(
    function () {
        setTimeout(
            function () {
                initialize();
            },
            200);
    });

    initialize();

} google.maps.event.addDomListener(window, 'load', init_map);
