﻿<%@ Page Language="C#" MasterPageFile="~/Views/Shared/BudrosSite.Master" Inherits="System.Web.Mvc.ViewPage<Budros.Web.Models.About.AboutViewModel>" %>

<asp:Content ID="Content2" runat="server" ContentPlaceHolderID="HeadPlaceHolder">
    <title>O Firmie - Deweloper Budros | Mieszkania na sprzedaż | Gdańsk - Budros</title>
    <meta name="title" content="O Firmie" />
    <meta name="description" content="Jesteśmy przedsiębiorstwem ogólnobudowlanym i rusztowaniowym, wykonującym inwestycje w sposób kompleksowy: od projektu do gotowego obiektu.  W tym roku nasza firma obchodzi dwudziestolecie istnienia, a przez ten okres czasu  zbudowaliśmy szereg obiektów o zróżnicowanym charakterze. " />
    <meta name="Keywords" content="Mieszkania Gdańsk Budros" />
</asp:Content>

<asp:Content ID="StylesheetsPlaceholder" runat="server" ContentPlaceHolderID="StylesheetsPlaceholder">
    <link href="../../Stylesheets/Shared/prettyphoto.css" rel="stylesheet" />
    <link href="../../Stylesheets/Shared/nivoslider.css" rel="stylesheet" />
    <link href="/Stylesheets/Shared/Photogallery/photogallery.css" rel="stylesheet" />
    <link href="/Stylesheets/About/about.css" rel="stylesheet" />
    <link href="/Stylesheets/About/about-mobile.css" rel="stylesheet" />
</asp:Content>

<asp:Content ID="Content" runat="server" ContentPlaceHolderID="ContentPlaceholder">
    <div class="container">
        <div id="backgroundholder" class="hidden"></div>
        <div class="col-md-3 noleftpadding mobile-norightpadding">
            <div class="col-md-12 logo-img noleftpadding mobile-norightpadding subheader-container">
                <div class="subheader js-background" style="background-color: #a32727">
                    <span class="js-subheader text-uppercase">
                        <%if (Model.InitialActiveTab == 0)
                          {%>
                        <%=ViewResources.AboutStrings.AboutUs%>
                        <%}%>
                        <%if (Model.InitialActiveTab == 1)
                          {%>
                        <%=ViewResources.AboutStrings.AwardsAndCertificates%>
                        <%}%>
                        <%if (Model.InitialActiveTab == 2)
                          {%>
                        <%=ViewResources.AboutStrings.Recommendations%>
                        <%}%>
                    </span>
                </div>
            </div>
            <div class="col-md-12 noleftpadding mobile-norightpadding left-menu-container">
                <ul class="navigation nav nav-pills nav-stacked left-menu text-uppercase js-background" style="background-color: #a32727">
                    <%if (Model.InitialActiveTab == 0)
                      {%>
                    <li class="active">
                        <%}
                      else
                      {%>
                        <li>
                            <%}%>
                            <a data-toggle="tab" href="#tab0" class="js-tab" data-subheader="<%=ViewResources.AboutStrings.AboutUs %>"><%=ViewResources.AboutStrings.AboutUs %></a></li>
                        <%if (Model.InitialActiveTab == 1)
                          {%>
                        <li class="active">
                            <%}
                          else
                          {%>
                            <li>
                                <%}%>
                                <a data-toggle="tab" href="#tab1" class="js-tab" data-subheader="<%=ViewResources.AboutStrings.AwardsAndCertificates%>"><%=ViewResources.AboutStrings.AwardsAndCertificates %></a></li>
                            <%if (Model.InitialActiveTab == 2)
                              {%>
                            <li class="active">
                                <%}
                              else
                              {%>
                                <li>
                                    <%}%>
                                    <a data-toggle="tab" href="#tab2" class="js-tab" data-subheader="<%=ViewResources.AboutStrings.Recommendations%>"><%=ViewResources.AboutStrings.Recommendations %></a></li>
                </ul>
                <div class="nopadding office js-background" style="background-color: #a32727">
                    <%if (Model.Office != null)
                      { %>
                    <span class="line header-address">
                        <h5 class="text-uppercase bold"><%=Model.Office.Name%></h5>
                    </span>
                    <div class="line">
                        <span class="tel">tel. <%=Model.Office.Phone %></span>
                    </div>
                    <div class="line">
                        <span class="tel">fax <%=Model.Office.Fax %></span>
                    </div>
                    <div class="line">
                        <span class="tel"><a href="mailto:<%=Model.Office.Email %>"><%=Model.Office.Email %></a></span>
                    </div>
                    <%} %>
                </div>
            </div>
        </div>
        <div class="col-md-9 noleftpadding norightpadding">
            <div class="tab-content text-justify">
                <%if (Model.InitialActiveTab == 0)
                  {%>
                <div id="tab0" class="tab-pane fade in active">
                    <%}
                  else
                  {%>
                    <div id="tab0" class="tab-pane fade in">
                        <%}%>
                        <%if (Model.MainSection != null)
                          {
                              Html.RenderPartial("AboutMainSection", Model.MainSection);
                          }%>
                    </div>
                    <%if (Model.InitialActiveTab == 1)
                      {%>
                    <div id="tab1" class="tab-pane fade in active">
                        <%}
                      else
                      {%>
                        <div id="tab1" class="tab-pane fade in">
                            <%}%>
                            <%if (Model.Certificates != null)
                              {
                                  Html.RenderPartial("Certificates", Model.Certificates);
                              }%>
                        </div>

                        <%if (Model.InitialActiveTab == 2)
                          {%>
                        <div id="tab2" class="tab-pane fade in active references">
                            <%}
                          else
                          {%>
                            <div id="tab2" class="tab-pane fade in references">
                                <%}%>
                                <%if (Model.References != null)
                                  {
                                      Html.RenderPartial("Modules/Gallery", Model.References);
                                  }%>
                            </div>
                        </div>
                    </div>
                </div>
</asp:Content>

<asp:Content ID="ScriptsPlaceHolder" runat="server" ContentPlaceHolderID="ScriptsPlaceHolder">
    <script src="<%=Url.Content("~/Scripts/3rdParty/foundation.min.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/3rdParty/jquery.nivo.slider.pack.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/3rdParty/jquery.prettyPhoto.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/3rdParty/custom.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/3rdParty/jquery.isotope.min.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/3rdParty/bootstrap.min.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/App/Shared/tabSwitch.js")%>"></script>
</asp:Content>
