﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<Budros.Web.Models.About.RecommendationsViewModel>" %>
<%@ Import Namespace="Budros.Web.Enumerators" %>
<%@ Import Namespace="Budros.Web.Helpers" %>
<div class="row">
    <div class="col-lg-12">
        <h3 class="page-header"><%=ViewResources.AboutStrings.Recommendations %></h3>
    </div>
    <div class="col-lg-12">
        <!-- CATEGORIES-->
        <section id="options" class="clearfix">
            <ul id="filters" class="option-set clearfix" data-option-key="filter">
                <li><a href="#filter" data-option-value="*" class="portofoliobutton selected">
                    <%=ViewResources.AboutStrings.ShowAll%>
                </a></li>

                <%foreach (var category in Model.GeneralCategories)
                  { %>

                <li><a href="#filter" data-option-value=".<%=category.Option%>" class="portofoliobutton">
                    <%=category.Name%></a></li>
                <%} %>
            </ul>
        </section>
    </div>
    <div id="portofolio" class="col-lg-12">
        <%
            if (Model.RecommendationsCategories != null)
            {
                foreach (var recommendationCategory in Model.RecommendationsCategories)
                {%>
        <div class=" category <%=recommendationCategory.Category %> col-md-3">
            <div class="portofoliothumb">
                <ul class="list-group">
                    <h6>
                        <%if (recommendationCategory.Items != null)
                          {
                              foreach (var item in recommendationCategory.Items)
                              {%>
                        <li class="list-group-item">
                            <a class="recommendation-link" href="<%=Url.Action("PdfViewer","About", new {file = item.Url}) %>" target="_blank">
                                <span class="glyphicon glyphicon-file" aria-hidden="true"></span>&nbsp<%=item.Title %>
                            </a>
                        </li>
                        <%}
                          }
                        %>
                    </h6>
                </ul>
            </div>
        </div>
        <%}
            }
        %>
    </div>
</div>
