﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<Budros.Web.Models.Projects.ProjectApartmentsPlanViewModel>" %>

<div id="viewStrings" class="hidden"
    data-building="<%=ViewResources.ProjectsStrings.Building %>"
    data-basefloor="<%=ViewResources.ProjectsStrings.BaseFloor %>"
    data-floor="<%=ViewResources.ProjectsStrings.Condignation %>">
</div>
<div class="row canvas-row mobile-margin-top">
    <div class="col-lg-12 col-md-12 col-xs-12">
        <div class="tab-entry-header js-building-plan-header">
            <div class="tab-entry-header-content js-border js-font text-uppercase">
                <%=ViewResources.ProjectsStrings.BuildingPlan %>
            </div>
        </div>
    </div>
    <div class="col-lg-12 col-md-12 col-xs-12 navigation-panel hidden">
        <div class="navigation-panel-content js-border">
            <div class="js-show-buildings-plan-btn show-buildings-plan-btn" title="<%=ViewResources.ProjectsStrings.ReturnToBuildingsPlan %>">
                <span class="glyphicon glyphicon-chevron-left building-content-arrow js-font" aria-hidden="true"></span>
                <span class="building-content js-building-content js-font"></span>
            </div>
            <div class="js-floor-select floor-select">
                <ul class="floor-list js-floor-list"></ul>
            </div>
        </div>
    </div>
    <div class="col-lg-12 col-md-12 col-xs-11">
        <div class="popup">
            <img alt="gallery-image" src="<%: Url.Action("GetLogo", "Projects", new { projectId = Model.ProjectId}) %>" />
            <span></span>
        </div>
        <img alt="gallery-image" class="buildings-plan hidden" src="<%: Url.Action("GetBuildingsPlanImage", "Projects", new { projectId = Model.ProjectId}) %>" />
        <% if (Model.Buildings != null)
           {
               foreach (var building in Model.Buildings)
               {
                   if (building.Floors != null)
                   {
                       foreach (var floor in building.Floors)
                       {%>
        <img alt="gallery-image" class="hidden floor-plan" data-buildingid="<%=building.Id %>" data-level="<%=floor.Level %>"
            src="<%: Url.Action("GetFloorPlanImage", "Projects", new { floorId = floor.Id}) %>" />
        <%}
                   }
               }
           }%>
        <canvas id="generalPlanCanvas" />
    </div>
</div>
<div class="row compass-row js-apartments-legend hidden">
    <div class="col-lg-4 col-md-4 col-xs-11">
        <div class="apartments-status-container">
            <div>
                <div class="status-square-free">&nbsp;</div>
                <span class="text-uppercase"><%=ViewResources.ProjectsStrings.Free %></span>
            </div>
            <div>
                <div class="status-square-sold">&nbsp;</div>
                <span class="text-uppercase"><%=ViewResources.ProjectsStrings.Sold %></span>
            </div>
            <div>
                <div class="status-square-reserved">&nbsp;</div>
                <span class="text-uppercase"><%=ViewResources.ProjectsStrings.Reserved %></span>
            </div>
        </div>
    </div>
    <%--    <div class="col-lg-8 col-md-8 col-xs-8">
        <div>
            <img class="compass-image" src="/Images/Shared/strzalka.jpg" />
        </div>
        <div class="compass-text text-uppercase js-choose-building-text"><%=ViewResources.ProjectsStrings.ChooseBuilding %></div>
        <div class="hidden compass-text text-uppercase js-choose-apartment-text"><%=ViewResources.ProjectsStrings.ChooseApartment %></div>
    </div>--%>
</div>
