﻿<%@ Page Language="C#" MasterPageFile="~/Views/Shared/BudrosSite.Master" Inherits="System.Web.Mvc.ViewPage<Budros.Web.Models.Projects.ProjectsViewModel>" %>

<asp:Content ID="Content2" runat="server" ContentPlaceHolderID="HeadPlaceHolder">
    <title>Sprzedaż Mieszkań - Deweloper Budros | Mieszkania na sprzedaż | Gdańsk - Budros</title>
    <meta name="title" content="Sprzedaż Mieszkań" />
    <meta name="description" content="Polecamy Państwu niezwykle atrakcyjne mieszkania Gdańsk. Zapewniamy wysoki standard wykończenia, terminowość, profesjonalizm oraz solidne i precyzyjne usługi. Budros to znakomity, godny zaufania deweloper." />
    <meta name="keywords" content="Mieszkania Gdańsk" />
</asp:Content>

<asp:Content ID="StylesheetsPlaceholder" runat="server" ContentPlaceHolderID="StylesheetsPlaceholder">
    <link href="/Stylesheets/Projects/projects.css" rel="stylesheet" />
    <link href="/Stylesheets/Shared/prettyphoto.css" rel="stylesheet" />
    <link href="/Stylesheets/Shared/nivoslider.css" rel="stylesheet" />
    <link href="/Stylesheets/Shared/Photogallery/photogallery.css" rel="stylesheet" />
</asp:Content>

<asp:Content ID="Content" runat="server" ContentPlaceHolderID="ContentPlaceholder">
    <div class="container">
        <div class="col-lg-12 noleftpadding">
            <!-- CATEGORIES-->
            <section id="options" class="clearfix">
                <ul id="filters" class="option-set clearfix" data-option-key="filter">
                    <li><a href="#filter" data-option-value="*" class="portofoliobutton selected">
                        <%=ViewResources.ProjectsStrings.All%>
                    </a></li>

                    <%foreach (var category in Model.GeneralCategories)
                      { %>

                    <li><a href="#filter" data-option-value=".<%=category%>" class="portofoliobutton">
                        <%=category%></a></li>
                    <%} %>
                </ul>
            </section>
        </div>
        <div class="row">
            <div id="portofolio" class="isotope-items-row col-lg-12 noleftpadding">
                <% 
                    if (Model.Projects != null)
                    {
                        foreach (var item in Model.Projects)
                        {%>
                <div class="category <%=item.Location %> col-lg-4">
                    <div class="portofoliothumb">
                        <div class="item-description">
                            <h4><%=item.Title %> / <%=item.Location %></h4>
                        </div>
                        <a href="<%: Url.Action("ProjectDetails", "Projects", new { projectDetailsId = item.ProjectId}) %>"> 
                            <img src="<%: Url.Action("GetMainImage", "Projects", new { projectId = item.ProjectId}) %>" class="img-responsive customer-img item-image" alt="gallery-image"/>
                        </a>
                    </div>
                </div>
                <%}
                    }%>
            </div>
        </div>
    </div>
</asp:Content>

<asp:Content ID="ScriptsPlaceHolder" runat="server" ContentPlaceHolderID="ScriptsPlaceHolder">
    <script src="<%=Url.Content("~/Scripts/3rdParty/foundation.min.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/3rdParty/jquery.nivo.slider.pack.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/3rdParty/jquery.prettyPhoto.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/3rdParty/custom.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/3rdParty/jquery.isotope.min.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/3rdParty/bootstrap.min.js")%>"></script>
</asp:Content>
