﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl" %>
<div class="sliding-panel">
    <div class="sliding-panel-inner-header text-uppercase">
        <i class="fa fa-envelope-o fa-rotate-90 sliding-panel-icon"></i>
        <span class="mobile-hidden"><%=ViewResources.SharedStrings.ContactUs %></span>
    </div>
    <div class="sliding-panel-inner-content">
        <div class="text-uppercase">
            <%=ViewResources.SharedStrings.SalesOffice %>
            <div class="phone-icon">
                <abbr title="<%=ViewResources.ContactStrings.Phone %>"><i class="fa fa-phone fa-4x"></i></abbr>
            </div>
            <div class="phones-list">
                +48 784 065 494<br />
                +48 662 231 906<br />
                +48 58 326 10 63
            </div>
        </div>
        <div>
            <div class="email-icon">
                <abbr title="<%=ViewResources.ContactStrings.Email %>"><i class="fa fa-envelope-o fa-2x"></i></abbr>
            </div>
            <div class="emails-list">
                <a style="color: black;" href="MAILTO:mieszkania@budros.pl">mieszkania@budros.pl</a>
            </div>
        </div>
        <div>
            <form name="sentMessageSlide" id="contactFormSlide">
                <div class="control-group form-group">
                    <div class="controls">
                        <label><%=ViewResources.ContactStrings.SenderName %>:</label>
                        <input type="text" class="form-control" id="sliding-name" />
                    </div>
                </div>
                <div class="control-group form-group">
                    <div class="controls">
                        <label><%=ViewResources.ContactStrings.SenderEmail %>:</label>
                        <input type="text" class="form-control" id="sliding-email" />
                    </div>
                </div>
                <div class="control-group form-group">
                    <div class="controls">
                        <label><%=ViewResources.ContactStrings.Message %>:</label>
                        <textarea rows="10" cols="100" class="form-control" id="sliding-message" maxlength="999" style="resize: none"></textarea>
                    </div>
                </div>
                <div id="success"></div>
                <!-- For success/fail messages -->
                <input id="submit-btn-slide" type="submit" class="btn btn-primary" value="<%=ViewResources.ContactStrings.Send %>" onclick="return sendEmail();" />
            </form>
        </div>
    </div>
</div>

<script src="<%=Url.Content("~/Scripts/App/Contact/contact-slider.js")%>"></script>
