﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<Budros.Web.Models.Shared.Menu.MenuHeaderViewModel>" %>

<div class="container nopadding mobile-main-header">
    <div class="navbar-header pull-left ">
        <div id="o-wrapper" class="o-wrapper">
            <div class="o-container">
                <div class="c-buttons">
                    <button type="button" id="c-button--slide-left" class="navbar-toggle menu-button c-button" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1">
                        <span class="glyphicon glyphicon-menu-hamburger "></span>
                        <span class="icon-bar"></span>
                    </button>
                </div>
            </div>
        </div>
    </div>
    <div class="pull-right main-icon">
        <a href="/Home">
            <img src="/Images/Shared/budros.jpg" class="img-responsive" alt="budros.jpg">
        </a>
    </div>
    <div class="navbar-collapse navigation-menu c-menu c-menu--slide-left" id="c-menu--slide-left">
        <button class="c-menu__close"><i class="fa fa-times-circle"></i></button>
        <ul class="nav navbar-nav navbar-left text-uppercase vertical-center c-menu__items mobile-noleftmargin mobile-norightmargin">
            <li class="main-menu-item">
                <a href="/Home" style="padding: 0px;">
                    <img src="/Images/Shared/budros.jpg" class="img-responsive main-logo-img" alt="budros.jpg">
                </a>
            </li>


            <%if (!Model.IsGerman)
              {%>
            <li class="menu-header menu-header-single-line">
                <%= Html.ActionLink(ViewResources.SharedStrings.Apartments, "Projects","Projects") %>

                <%if (Model.Projects != null)
                  {%>
                <ul class="menu-item">
                    <%foreach (var project in Model.Projects)
                      {%>
                    <li class="noleftpadding">
                        <a href="<%: Url.Action("ProjectDetails", "Projects", new { projectDetailsId = project.ProjectId}) %>">
                            <span class="menu-item-container">
                                <div class="menu-item-text">
                                    <img src="<%: Url.Action("GetLogo", "Projects", new { projectId = project.ProjectId}) %>" class="img-responsive menu-item-img" alt="gallery-image"><div><%=project.Title %> / <%=project.Location %></div>
                                </div>
                            </span>
                        </a>
                    </li>
                    <%}%>
                </ul>
                <%}%>
            </li>
            <%}%>
            <li class="menu-header menu-header-single-line">
                <%= Html.ActionLink(ViewResources.SharedStrings.About, "About","About") %>
                <ul class="menu-item">
                    <li>
                        <a href="<%: Url.Action("AboutWithActiveTab", "About", new { tabId = 0}) %>">
                            <span class="menu-item-container">
                                <div class="menu-item-text menu-item-text-with-margin">
                                    <%=ViewResources.AboutStrings.AboutUs %>
                                </div>
                            </span>
                        </a>
                    </li>
                    <li>
                        <a href="<%: Url.Action("AboutWithActiveTab", "About", new { tabId = 1}) %>">
                            <span class="menu-item-container">
                                <div class="menu-item-text menu-item-text-with-margin">
                                    <%=ViewResources.AboutStrings.AwardsAndCertificates %>
                                </div>
                            </span>
                        </a>
                    </li>
                    <li>
                        <a href="<%: Url.Action("AboutWithActiveTab", "About", new { tabId = 2}) %>">
                            <span class="menu-item-container">
                                <div class="menu-item-text menu-item-text-with-margin">
                                    <%=ViewResources.AboutStrings.Recommendations %>
                                </div>
                            </span>
                        </a>
                    </li>
                </ul>
            </li>
            <%if (!Model.IsGerman)
              {%>
            <li class="menu-header">
                <%= Html.ActionLink(ViewResources.SharedStrings.GeneralDevelopment, "GeneralDevelopment","GeneralDevelopment") %>
                <ul class="menu-item">
                    <%--                    <li>
                        <a href="<%: Url.Action("GeneralDevelopmentWithActiveTab", "GeneralDevelopment", new { tabId = 0}) %>">
                            <div class="menu-item-text">
                                <%=ViewResources.GeneralDevelopmentStrings.CompanyActivity%>
                            </div>
                        </a>
                    </li>--%>
                    <li>
                        <a href="<%: Url.Action("GeneralDevelopmentWithActiveTab", "GeneralDevelopment", new { tabId = 0}) %>">
                            <div class="menu-item-text">
                                <%=ViewResources.GeneralDevelopmentStrings.CompanyScope%>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a href="<%: Url.Action("GeneralDevelopmentWithActiveTab", "GeneralDevelopment", new { tabId = 1}) %>">
                            <div class="menu-item-text">
                                <%=ViewResources.GeneralDevelopmentStrings.Railings%>
                            </div>
                        </a>
                    </li>
                </ul>
            </li>
            <%} %>
            <li class="menu-header">
                <%= Html.ActionLink(ViewResources.SharedStrings.ExportServices, "ExportServices","ExportServices") %>
                <%--<ul class="menu-item">
                    <li>
                        <a href="<%: Url.Action("ExportServicesWithActiveTab", "ExportServices", new { tabId = 0}) %>">
                            <div class="menu-item-text">
                                <%=ViewResources.ExportServicesStrings.AboutExportServices%>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a href="<%: Url.Action("ExportServicesWithActiveTab", "ExportServices", new { tabId = 0}) %>">
                            <div class="menu-item-text">
                                <%=ViewResources.ExportServicesStrings.Contracts%>
                            </div>
                        </a>
                    </li>
                </ul>--%>
            </li>
            <li class="menu-header menu-header-single-line">
                <%= Html.ActionLink(ViewResources.SharedStrings.Developed, "Developed","Developed") %>
            </li>
            <li class="menu-header menu-header-single-line">
                <%= Html.ActionLink(ViewResources.SharedStrings.Contact, "Contact","Contact") %>
            </li>
            <li class="lang-box">
                <a class="lang-item lang-item-pl" href="<%: Url.Action("ChangeCulture", "Home", new { lang = "", returnUrl = this.Request.RawUrl }) %>"></a>
                <a class="lang-item lang-item-ge" href="<%: Url.Action("ChangeCulture", "Home", new { lang = "de", returnUrl = this.Request.RawUrl }) %>"></a>
            </li>
        </ul>
    </div>
</div>
